'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
@author: Jimmy Li
'''

from Tkinter import *
from tkSimpleDialog import Dialog
import tkMessageBox
from config.Robots import Robots

class NewDesignDialog(Dialog):
    def __init__(self, parent):
        Dialog.__init__(self, parent, "New Program")
    
    def body(self, master):
        Label(master, text="Choose a set of state variables").grid(row=0, column=0, columnspan=2, sticky=W, pady=8, padx=8)
        listFrame = Frame(master)
        listFrame.grid(row=1, column=0, sticky=(N,S,W), padx=8)
        scrollbar = Scrollbar(listFrame, orient=VERTICAL)
        self.list = Listbox(listFrame, selectmode=SINGLE, height=25, width=15, yscrollcommand=scrollbar.set, exportselection=0)
        scrollbar.config(command=self.list.yview)
        self.list.pack(side=LEFT, fill=BOTH)
        scrollbar.pack(side=LEFT, fill=Y)
        self.list.bind("<<ListboxSelect>>", self.clickList)
        
        master.rowconfigure(1, weight=1)
        master.columnconfigure(1, weight=1)
        
        previewFrame = LabelFrame(master, text="Preview", padx=5)
        previewFrame.grid(row=1, column=1, padx=8, sticky=(N,S,E,W))
        previewFrame.rowconfigure(0, weight=1)
        previewFrame.columnconfigure(0, weight=1)
        #self.preview = Text(previewFrame, wrap=NONE, width=70, background="#d9d9d9", borderwidth=0, state=DISABLED)
        scrollbar = Scrollbar(previewFrame, orient=VERTICAL)
        scrollbar2 = Scrollbar(previewFrame, orient=HORIZONTAL)
        self.preview = Text(previewFrame, wrap=NONE, xscrollcommand=scrollbar2.set, yscrollcommand=scrollbar.set, borderwidth=0)
        scrollbar.config(command=self.preview.yview)
        scrollbar2.config(command=self.preview.xview)
        self.preview.grid(row=0, column=0, sticky=(N,S,E,W))
        scrollbar.grid(row=0, column=1, sticky=(N,S,E))
        scrollbar2.grid(row=1, column=0, sticky=(E,W,S))
        
        self.listData = []
        
        for robot in Robots.stateVarSets:
            self.listData.append(robot)
        
        self.listData = sorted(self.listData)
        
        for robot in self.listData:
            self.list.insert(END, robot)
        
        
    def clickList(self, event):
        sel = self.list.curselection()
        index = int(sel[0])
        
        self.stateVars = []
        
        for stateVar in Robots.stateVarSets[self.listData[index]]['stateVars']:
            self.stateVars.append(stateVar)
    
        self.stateVars = sorted(self.stateVars)
        self.preview.delete(1.0, END)
        for stateVar in self.stateVars:
            infoStr = ""
            stateVarInfo = Robots.stateVarSets[self.listData[index]]['stateVars'][stateVar]
            infoStr += 'writable: '+str(stateVarInfo['writable'])
            if stateVarInfo.has_key('unit'):
                infoStr += ', unit: '+stateVarInfo['unit']
            if stateVarInfo.has_key('error'):
                infoStr += ', error: '+("%.2f" % stateVarInfo['error'])
            if stateVarInfo.has_key('description'):
                infoStr += ', description: '+stateVarInfo['description']
                
            self.preview.insert(END, stateVar+' - '+infoStr+"\n")
        
    def validate(self):
        if len(self.list.curselection()) > 0:
            return True
        tkMessageBox.showerror("Error", "You need to select a set of state variables to work with. If you do not see anything in the list box, then you need to add at least one state variable set in config/Robots.py.")
    
    def apply(self):
        self.result = self.listData[int(self.list.curselection()[0])]
