'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2010-05-26

@author: Jimmy Li
'''

from Tkinter import *
from tkSimpleDialog import Dialog
from control.DataBoard import DataBoard
import gui.Utils

class AttachMetaController(Dialog):
    def __init__(self, parent):
        self.ip = DataBoard.cacheIP
        self.port = DataBoard.cachePort
        Dialog.__init__(self, parent, "Attach to Meta-controller")
    
    def body(self, master):
        Label(master, text="IP").grid(row=0, column=0, padx=3, pady=5, sticky=E)
        self.ipEntry = Entry(master)
        self.ipEntry.grid(row=0, column=1, padx=3, pady=5, sticky=W)
        self.ipEntry.insert(0, self.ip)
        
        Label(master, text="Port").grid(row=1, column=0, padx=5, pady=5, sticky=E)
        self.comPortEntry = Entry(master)
        self.comPortEntry.grid(row=1, column=1, padx=2, sticky=W)
        self.comPortEntry.insert(0,self.port)
        
    def buttonbox(self):
        # add standard button box. override if you don't want the
        # standard buttons
        
        box = Frame(self)

        self.startButton = Button(box, text="Attach", width=10, command=self.attachMetaController)
        self.startButton.pack(side=LEFT, padx=5, pady=5)
        
        self.closeButton = Button(box, text="Cancel", width=10, command=self.closeDialog)
        self.closeButton.pack(side=LEFT, padx=5, pady=5)

        box.grid(row=1, column=0, pady=5, padx=5)
    
    def attachMetaController(self):
        DataBoard.cacheIP = self.ipEntry.get()
        DataBoard.cachePort = self.comPortEntry.get()
        gui.Utils.attachMetaController(host=self.ipEntry.get(), port=int(self.comPortEntry.get()))
        DataBoard.mainWindowHandle.runMenu.entryconfig(2, state=DISABLED)
        DataBoard.mainWindowHandle.runMenu.entryconfig(3, state=NORMAL)
        DataBoard.mainWindowHandle.runMenu.entryconfig(4, state=NORMAL)
        DataBoard.mainWindowHandle.runMenu.entryconfig(5, state=DISABLED)
        DataBoard.mainWindowHandle.runMenu.entryconfig(6, state=DISABLED)
        self.closeDialog()

    def closeDialog(self):
        self.cancel()
