'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''


'''
Created on 2010-06-01

@author: Jimmy Li
'''

from control.DataBoard import DataBoard
import control.Utils
from config.Robots import Robots
import copy
import time
from Tkinter import *
import os
import gui.AsyncClient
import socket, asyncore, asynchat
import threading
import pickle

"""
Valid Stipples:

"error"
"gray75"
"gray50"
"gray25"
"gray12"
"hourglass"
"info"
"questhead"
"question"
"warning"
"""

def attachMetaController(host=DataBoard.defaultIP, port=DataBoard.defaultPort):
    if DataBoard.attachedToMetaController:
        detachMetaController()
    client = gui.AsyncClient.Client(host=host, port=port)
    client_thread = threading.Thread(target = asyncore.loop)
    client_thread.setDaemon(True)
    client_thread.start()
    DataBoard.asyncClient = client
    DataBoard.attachedToMetaController = True

def detachMetaController():
    if not DataBoard.asyncClient == None:
        DataBoard.asyncClient.close()
    DataBoard.asyncClient = None
    DataBoard.asyncClientThread = None
    DataBoard.attachedToMetaController = False

def updateDesignersVisualizing(target, parameters):
    for des in DataBoard.designers:
        if not des is target:
            des.updateIfVisualizing(parameters)

def reinitAllDesigners():
    for des in DataBoard.designers:
        des.initVisualization()
        des.redrawVisualization()

def redrawAllDesigners():
    for des in DataBoard.designers:
        des.redrawVisualization()

def updateRegionEditors():
    for editor in DataBoard.regEditors:
        editor.refreshRegionList()
        editor.updateSelectedRegion()
        
    for editor in DataBoard.boolEditors:
        editor.refreshRegionList()

def updateWaypointEditors():
    for editor in DataBoard.wptEditors:
        editor.refreshWayptSetList()
        editor.refreshWayptsList()
        editor.updateSelectedWaypt()

def updateDesignerStatusBars():
    for des in DataBoard.designers:
        des.updateStatusBar()

def removeDesigner(target):
    for des in DataBoard.designers:
        if des is target:
            DataBoard.designers.remove(des)
            break

def removeRegEditor(target):
    for editor in DataBoard.regEditors:
        if editor is target:
            DataBoard.regEditors.remove(editor)
            break

def removeWptEditor(target):
    for editor in DataBoard.wptEditors:
        if editor is target:
            DataBoard.wptEditors.remove(editor)
            break

def removeBoolEditor(target):
    for editor in DataBoard.boolEditors:
        if editor is target:
            DataBoard.boolEditors.remove(editor)
            break

def addToHistory():
    if DataBoard.pointInHistory < len(DataBoard.history)-1:
        del DataBoard.history[DataBoard.pointInHistory+1:]
    
    regEditorCursor = None
    wptEditorCursor = None
    # TODO: If in the future we want to have multiple region text editors, the following
    # two if blocks will need to be fixed
    if len(DataBoard.regEditors) > 0:
        regEditor = DataBoard.regEditors[0]
        if not regEditor.editingRegion == None:
            regEditorCursor = regEditor.regionCommandEditor.index(INSERT)
            
    if len(DataBoard.wptEditors) > 0:
        wptEditor = DataBoard.wptEditors[0]
        if not wptEditor.editingWayptSet == None:
            wptEditorCursor = wptEditor.wayptCommandEditor.index(INSERT)
            
    DataBoard.history.append(
            {
             'wptSet': copy.deepcopy(DataBoard.waypointSets), 
             'region': copy.deepcopy(DataBoard.regions), 
             'boolRegion': copy.deepcopy(DataBoard.booleanRegions),
             'selectedRegion': DataBoard.selectedRegion,
             'selectedWaypointSet': DataBoard.selectedWaypointSet,
             'selectedWaypoint': DataBoard.selectedWaypoint,
             'regEditorCmdCursor': regEditorCursor,
             'wptEditorCmdCursor': wptEditorCursor
            }
    )
    DataBoard.historyModifiedTime = time.time()
    DataBoard.pointInHistory = len(DataBoard.history)-1
    
    
def modified(atomic=False):
    DataBoard.modified = True
    DataBoard.modifiedTime = time.time()
    if atomic or time.time() - DataBoard.historyModifiedTime > 1.0:
        addToHistory()
        if DataBoard.pointInHistory > 0:
            DataBoard.mainWindowHandle.editMenu.entryconfig(1, state=NORMAL)
            DataBoard.undoEnabled = True
        DataBoard.mainWindowHandle.editMenu.entryconfig(2, state=DISABLED)
        DataBoard.redoEnabled = False

def getImagePath():
    pathname = os.path.dirname(sys.argv[0])
    abspathname = os.path.abspath(pathname)
    return os.path.join(abspathname,'image')

def undo(event=None):
    if not DataBoard.undoEnabled:
        return
    if DataBoard.modifiedTime > DataBoard.historyModifiedTime:
        addToHistory()
    
    DataBoard.pointInHistory -= 1
    
    DataBoard.regions = copy.deepcopy(DataBoard.history[DataBoard.pointInHistory]['region'])
    DataBoard.booleanRegions = copy.deepcopy(DataBoard.history[DataBoard.pointInHistory]['boolRegion'])
    DataBoard.waypointSets = copy.deepcopy(DataBoard.history[DataBoard.pointInHistory]['wptSet'])
    DataBoard.selectedRegion = DataBoard.history[DataBoard.pointInHistory]['selectedRegion']
    DataBoard.selectedWaypointSet = DataBoard.history[DataBoard.pointInHistory]['selectedWaypointSet']
    DataBoard.selectedWaypoint = DataBoard.history[DataBoard.pointInHistory]['selectedWaypoint']
    
    DataBoard.mainWindowHandle.editMenu.entryconfig(2, state=NORMAL)
    DataBoard.redoEnabled = True
    if DataBoard.pointInHistory <= 0:
        DataBoard.mainWindowHandle.editMenu.entryconfig(1, state=DISABLED)
        DataBoard.undoEnabled = False
    
    updateRegionEditors()
    updateWaypointEditors()
    
    # TODO: If in the future we want to have multiple region text editors, the following
    # two if blocks will need to be fixed
    if len(DataBoard.regEditors) > 0:
        regEditor = DataBoard.regEditors[0]
        if not regEditor.editingRegion == None:
            regEditor.regionCommandEditor.mark_set(INSERT, DataBoard.history[DataBoard.pointInHistory]['regEditorCmdCursor']) 
            
    if len(DataBoard.wptEditors) > 0:
        wptEditor = DataBoard.wptEditors[0]
        if not wptEditor.editingWayptSet == None:
            wptEditor.wayptCommandEditor.mark_set(INSERT, DataBoard.history[DataBoard.pointInHistory]['wptEditorCmdCursor'])
    
    reinitAllDesigners()
    
def redo(event=None):
    if not DataBoard.redoEnabled:
        return
    
    DataBoard.pointInHistory += 1
   
    DataBoard.regions = copy.deepcopy(DataBoard.history[DataBoard.pointInHistory]['region'])
    DataBoard.booleanRegions = copy.deepcopy(DataBoard.history[DataBoard.pointInHistory]['boolRegion'])
    DataBoard.waypointSets = copy.deepcopy(DataBoard.history[DataBoard.pointInHistory]['wptSet'])
    DataBoard.selectedRegion = DataBoard.history[DataBoard.pointInHistory]['selectedRegion']
    DataBoard.selectedWaypointSet = DataBoard.history[DataBoard.pointInHistory]['selectedWaypointSet']
    DataBoard.selectedWaypoint = DataBoard.history[DataBoard.pointInHistory]['selectedWaypoint']
    
    DataBoard.mainWindowHandle.editMenu.entryconfig(1, state=NORMAL)
    DataBoard.undoEnabled = True
    if DataBoard.pointInHistory >= len(DataBoard.history)-1:
        DataBoard.mainWindowHandle.editMenu.entryconfig(2, state=DISABLED)
        DataBoard.redoEnabled = False
    
    updateRegionEditors()
    updateWaypointEditors()
    
    # TODO: If in the future we want to have multiple region text editors, the following
    # two if blocks will need to be fixed
    if len(DataBoard.regEditors) > 0:
        regEditor = DataBoard.regEditors[0]
        if not regEditor.editingRegion == None:
            regEditor.regionCommandEditor.mark_set(INSERT, DataBoard.history[DataBoard.pointInHistory]['regEditorCmdCursor']) 
            
    if len(DataBoard.wptEditors) > 0:
        wptEditor = DataBoard.wptEditors[0]
        if not wptEditor.editingWayptSet == None:
            wptEditor.wayptCommandEditor.mark_set(INSERT, DataBoard.history[DataBoard.pointInHistory]['wptEditorCmdCursor'])
    
    reinitAllDesigners()

def visualizeLogEntry(line):
    line = line.strip()
    if line == '':
        return
    firstSpace = line.find(' ')
    firstColon = line.find(':')
    msgtype = line[firstSpace+1:firstColon]
    if msgtype == 'STATE':
        redrawRobotPosition(line[firstColon+2:])

def redrawRobotPosition(posString):
    exec('robotPos = '+posString)
    for des in DataBoard.designers:
        des.redrawRobotPosition(robotPos)
    
def removeRobotImage():
    for des in DataBoard.designers:
        des.removeRobotImage()

def rcSetup():
    DataBoard.rcData = {}
    
    home = os.path.expanduser('~')
    rcFilePath = os.path.join(home, '.gssprc')
    #print 'using file', rcFilePath
    try: 
        rcFile = open(rcFilePath, 'r')
    except:
        return
    
    for line in rcFile.readlines():
        line = line.strip()
        if line == '':
            continue
        if line[0:1] == '#':
            continue
        keyVal = line.split('=', 1)
        key = keyVal[0].strip()
        val = keyVal[1].strip()
        DataBoard.rcData[key] = val
    
    rcFile.close()

def rcCleanup():
    home = os.path.expanduser('~')
    rcFilePath = os.path.join(home, '.gssprc')
    #print 'saving file', rcFilePath
    try: 
        rcFile = open(rcFilePath, 'w')
    except:
        return
    
    for key in DataBoard.rcData:
        rcFile.write(key+'='+str(DataBoard.rcData[key])+"\n")
     
    rcFile.close()
'''
def importModule(file):
    obj = pickle.load(file)

def exportModule(file):
    obj = control.Utils.createSaveObject()
    obj['stateVars'] = Robots.stateVarSets[obj['stateVarSet']]['stateVars']
    pickle.dump(obj, file, pickle.HIGHEST_PROTOCOL)
''' 