'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''


'''
Created on 2011-06-15

@author: Jimmy Li
'''

import threading
import time
import tempfile
import uuid
import os
import subprocess
import gui.Utils
import re
from control.DataBoard import DataBoard

#class MonitorThread(threading.Thread):
class EditorManager():
    '''
    classdocs
    '''

    def __init__(self):
        '''
        Constructor
        '''
        #self.lock = threading.Lock()
        self.files = {}
        
        # Construct temporary directory
        try:
            self.tmpDir = os.path.join(tempfile.gettempdir(), "gssp" + str(uuid.uuid4()))
            #control.DataBoard.DataBoard.tmpFolder = self.tmpDir
            os.makedirs(self.tmpDir)
        except:
            print 'Could not create temporary directory'
            
        #threading.Thread.__init__(self)
    
    def addFile(self, obj, editor, filename):
        '''
        obj can be a region object or a waypoint object
        '''
        try:
            dir = os.path.join(self.tmpDir, str(uuid.uuid4()))
            os.makedirs(dir)
            filename = re.sub(r'\W+', '', filename.replace(" ", "_")) + ".py"
            filePath = os.path.join(dir, filename)
            
            F = open(filePath, 'w')
            F.write(obj.commands)
            F.close()
        except:
            return 'Could not create files in your temporary directory.'
        
        try:
            subprocess.Popen([editor, filePath])
            #time.sleep(0.1)
        except:
            return 'Could not execute the following command: '+editor+' '+filePath
        
        '''
        try:
            F = open(filePath, 'r')
            F.close()
        except:
            return 'Your external editor seems to prevent me from opening the file that it has opened.'
        '''
        
        #self.lock.acquire()
        #self.files[obj.id] = {'path': filePath, 'obj': obj, 'lmtime': os.stat(filePath).st_mtime}
        #self.lock.release()
        self.files[obj.id] = {'path': filePath, 'lmtime': os.stat(filePath).st_mtime}
        
        DataBoard.rcData['text_editor'] = editor
                
        return '1'
        
    def removeFile(self, obj):
        #self.lock.acquire()
        
        file = self.files[obj.id]
        
        F = open(file['path'], 'r')
        code = F.read()
        F.close()
        obj.commands = code
        #gui.Utils.modified()
        #gui.Utils.updateRegionEditors()
        #gui.Utils.updateWaypointEditors()
        del self.files[obj.id]
        
        #self.lock.release()
    
    '''
    def run(self):
        
        while 1:
            self.lock.acquire()
            for file in self.files:
                lmtime = os.stat(file['path']).st_mtime
                if not lmtime == file['lmtime']:
                    file['lmtime'] = lmtime
                    F = open(file['path'], 'r')
                    code = F.read()
                    F.close()
                    file['obj'].commands = code
                    gui.Utils.updateRegionEditors()
                    gui.Utils.updateWaypointEditors()
            self.lock.release()
            
            try:
                time.sleep(0.2)
            except:
                pass
    '''
            
