'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2010-07-26

@author: Jimmy Li
'''

import control.Utils
import control.DataBoard

class Waypoint():
    def __init__(self, x = 0, y = 0, z = 0):
        '''
        
        '''
        self.number = control.DataBoard.DataBoard.waypointNumCounter
        control.DataBoard.DataBoard.waypointNumCounter += 1
        self.id = "waypoint%d" % (self.number)
        #self.position = {'Position X': x, 'Position Y': y, 'Position Z': z}
        self.position = {}
        self.commands = ''
        self.temp = {}
    
    def __str__(self):
        return str(self.position)

class WaypointSet():
    def __init__(self):
        self.number = control.DataBoard.DataBoard.waypointSetNumCounter
        control.DataBoard.DataBoard.waypointSetNumCounter += 1
        
        self.color = control.Utils.getRandomColorHexCode()
        
        self.id = "waypointSet%d" % (self.number)
        
        self.name = "w%d" % (self.number)
        
        self.waypoints = []
        
    def __str__(self):
        return str(self.waypoints)

def dumpWaypoints():
    for id in control.DataBoard.DataBoard.waypointSets:
        print id
        for wpt in control.DataBoard.DataBoard.waypointSets[id].waypoints:
            print wpt