'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2010-05-27

@author: Jimmy Li
'''

class DataBoard():
    '''
    Shared data between all the modules.
    '''
    
    version = '1.0.1'
    
    currentStateVarSet = ''
    
    currentFile = ''
    
    """
    A list of prime numbers that will be used as IDs for the regions. This makes the
    following task easy:
    Suppose the following regions are created:
        1. 3-dimensional region with constraints for positionX, positionY, and positionZ
        2. 2-dimensional region with constraints for positionX and positionZ
        3. 4-dimensional region with constraints for positionX, positionY, positionZ, and batteryLevel
    The user now wants to create a 1-dimensional visualize showing only positionX. The problem is thus
    to find all the regions that contains a constraint for positionX. We do this using the following
    approach:
    
    Assign a prime number to each parameter.
    
    Define a dictionary called regions (done in RegionHolder). For each combination of dimensions, we calculate
    a key for that combination of dimensions. Suppose positionX is assigned 3; positionY is assigned 5;
    position z is assigned 13. Then, a region with positionX, positionY and positionZ constraints will
    have a key of 3*5*13 = 195. If a region is one dimensional and only has constraints for positionZ, then
    its key will be 13.
    
    When entering a region into the regions dictionary, we add the region to the array regions{key}.
    To solve the original problem of finding all regions that have constraints for positionX, all we
    have to do is loop through all the keys in regions, and see if the key is divisible by the key
    of positionX. If a key in regions satisfies this criteria, then that key in the regions dictionary 
    points to an array that contains a subset of the regions we need to visualize. If we do this for
    all the keys in regions, then we will find all the regions we need to visualize
    
    The regions dictionary is wrapped inside RegionHolder, to automate prime number assignments.
    
    The following call to control.Utils.primes generates a bunch of prime numbers that can be used.
    This specific call in effect caps the maximum number of parameters the robot 
    can have at 669, since there are 669 prime numbers that are less than 5000. Robots don't have
    over 669 parameters......right? We'll think of something when the need arises.
    """
    primes = None
    
    # Used when formulating the default name for newly created regions
    regionNumCounter = 1
    
    # Contains the set of regions created by the current design. See more explanations above
    regions = None
    
    # Waypoint radius defines how close the robot needs to get to a waypoint
    # in order to be considered at that waypoint. Defaults to 2 meters
    #waypointRadius = 2.0
    
    # Boolean regions
    booleanRegions = {}
    
    # The region that has been selected by the user. Takes Region's id attribute as value.
    # When a region is selected, the user can add dimensions to it, or add code to it
    selectedRegion = ''
    
    # A list of designer windows that are open. Used when an update in one window needs to trigger
    # updates in other windows
    designers = []
    
    regEditors = []
    
    wptEditors = []
    
    boolEditors = []
    
    # Waypoint stuff, analogous to the region stuff
    waypointSetNumCounter = 1
    waypointNumCounter = 1
    waypointSets = {} # Use the id attribute of a WaypointSet object as the key
    selectedWaypointSet = ''
    # selectedWaypoint indicates the waypoint in waypointSets[selectedWaypointSet] that is selected
    # Although control.Waypoint.WaypointSet.waypoints is a list with index starting at 0, 
    # selectedWaypoint should start at 1.
    selectedWaypoint = -1
    
    # Handler of the main window. The Region Editor is in the main window. Used when the user selects
    # a region in a designer, and the Region Editor is signalled. 
    mainWindowHandle = None
    
    metaControllerHandle = None
    
    playbackControllerHandle = None
    
    defaultIP = 'localhost'
    defaultPort = 9551
    cacheIP = 'localhost'
    cachePort = 9551
    
    #tmpFolder = ''
    
    extEditorManager = None
    
    '''
    This is for undo and redo. See gui.Utils
    When the user performs an action, and it has been 2 seconds since the last entry into history,
    then a new entry will be made.
    '''
    history=[]
    
    # If the user uses undo, pointInHistory will decrease; if the user uses redo, it will increase
    pointInHistory = 0
    
    # Last time history was added
    historyModifiedTime = 0
    
    undoEnabled = False
    redoEnabled = False
    
    # Has the current gssp design been modified since the last save
    modified = False
    
    # Last modified time
    modifiedTime = 0
    
    icon = None
    
    asyncClient = None
    asyncClientThread = None
    asyncServer = None
    
    attachedToMetaController = False
    
    logPlaybackThread = None
    
    rcData = None
