'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2010-05-26

@author: Jimmy Li
'''

class Robots():
    
    # Each entry in stateVarSets is a set of state variables. You can customize
    # the state variables you work with in the GUI by modifying 'Generic Robot'
    # or by creating another entry in stateVarSets. You will get to choose the
    # set you want to use when you do File -> New
    
    '''
    !!!! IMPORTANT !!!!
    Do not use any of the following characters when editing stateVarSets:
    
    \n (new line)
    :  (colon)
    ;  (semi-colon)
    
    '''
    stateVarSets = {    
              
       'Generic Robot': {
           'stateVars' :    {
                                'Position X':       {'unit':'m', 'writable': True, 'error':0.5},
                                'Position Y':       {'unit':'m', 'writable': True, 'error':0.5},
                                'Position Z':       {'unit':'m', 'writable': True, 'error':0.5},
                                'Battery Level':    {'unit':'%', 'writable': False},
                                'Velocity':         {'unit':'m/s', 'writable': True, 'error':0.1},
                                'Front Obstacle':   {'unit':'m', 'writable': False, 'description':'How far the robot is from an obstacle directly in front.'}
                            }
       },
       
       'Custom': {
           'stateVars' :    {
                                'Custom State-var 1':       {'unit':'m', 'writable': True, 'error':2},
                                'Custom State-var 2':       {'unit':'m', 'writable': False},
                                'Custom State-var 3':       {'unit':'m', 'writable': True, 'error':2},
                            }
       }
    }
