'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2010-05-26

@author: Jimmy Li
'''

from Tkinter import *
from tkSimpleDialog import Dialog
import tkMessageBox
from config.Robots import Robots
from control.DataBoard import DataBoard

class DesignerSettings(Dialog):
    def __init__(self, parent, title = None):
        self.stateVars = Robots.stateVarSets[DataBoard.currentStateVarSet]['stateVars']
        self.stateVarNames = []
        for v in self.stateVars:
            self.stateVarNames.append(v)
        self.stateVarNames = sorted(self.stateVarNames)        
        self.listBoxes = {}
        Dialog.__init__(self, parent, title)
    
    '''
    def createCheckboxSet(self, master, axis):
        """
        Creates a set of checkboxes for the given axis allowing the user to specify
        which parameters to visualize on the given axis
        """
        box = Frame(master)
        l = Label(box, text=axis+' axis:')
        l.grid(sticky=W)
        
        checkboxNames = []
        
        for checkbox in self.checkboxes:
            checkboxNames.append(checkbox)
        
        checkboxNames = sorted(checkboxNames)
        
        for checkbox in checkboxNames:
            c = Checkbutton(box, 
                            text=checkbox, 
                            variable=self.checkboxValues[axis][checkbox], 
                            state=self.checkboxes[checkbox]['status'])
            c.grid(sticky=W)
        box.pack(side=LEFT)
    '''
    
    def createStateVarListBox(self, master, axisName):
        f = Frame(master)
        f.rowconfigure(1, weight=1)
        f.columnconfigure(0, weight=1)
        Label(f, text=axisName).grid(row=0, column=0, columnspan=2)
        
        scrollbar = Scrollbar(f, orient=VERTICAL)
        self.listBoxes[axisName] = Listbox(f, exportselection=0, height=20, selectmode=MULTIPLE, yscrollcommand=scrollbar.set)
        self.listBoxes[axisName].grid(row=1, column=0, sticky=(N,S,E,W))
        scrollbar.config(command=self.listBoxes[axisName].yview)
        scrollbar.grid(row=1,column=1,sticky=(N,S))
        
        for n in self.stateVarNames:
            self.listBoxes[axisName].insert(END, n)
        
        return f
    
    def checkAxisFilled(self, axisName):
        if len(self.listBoxes[axisName].curselection()) > 0:
            return True
        tkMessageBox.showerror("Error", "Each axis must visualize at least one parameter.")
        return False
    
    def noOverlap(self, axisName1, axisName2):
        for n1 in self.listBoxes[axisName1].curselection():
            for n2 in self.listBoxes[axisName2].curselection():
                if n1 == n2: 
                    tkMessageBox.showerror("Error", "The same parameter cannot be visualized in multiple axis.")
                    return False
        return True
    
    def indexToVarNames(self, axisName):
        varlist = []
        for index in self.listBoxes[axisName].curselection():
            varlist.append(self.stateVarNames[int(index)])
        return varlist
    '''
    def apply(self):
        self.result = self.checkboxValues
    '''

# ===============================================================================
class DesignerSettings1D(DesignerSettings):
    """
    Dialog asking the user for what to visualize on a one dimensional design window
    """
    def __init__(self, parent):
        DesignerSettings.__init__(self, parent, title='1D Designer Settings')
        
    def body(self, master):
        master.columnconfigure(0,weight=1)
        master.rowconfigure(0, weight=1)
        f = self.createStateVarListBox(master, 'X axis')
        f.grid(row=0, column=0, padx=5, sticky=(N,S,E,W))
    
    def validate(self):
        return self.checkAxisFilled('X axis')

    def apply(self):
        self.result = {'X': self.indexToVarNames('X axis')}

# ===============================================================================
class DesignerSettings2D(DesignerSettings):
    """
    Dialog asking the user for what to visualize on a two dimensional design window
    """
    
    def __init__(self, parent):
        DesignerSettings.__init__(self, parent, title='2D Designer Settings')
        
    def body(self, master):
        master.columnconfigure(0,weight=1)
        master.columnconfigure(1,weight=1)
        master.rowconfigure(0, weight=1)
        f1 = self.createStateVarListBox(master, 'X axis')
        f1.grid(row=0, column=0, padx=5, sticky=(N,S,E,W))
        f2 = self.createStateVarListBox(master, 'Y axis')
        f2.grid(row=0, column=1, padx=5, sticky=(N,S,E,W))
    
    def validate(self):
        return self.checkAxisFilled('X axis') and self.checkAxisFilled('Y axis') and self.noOverlap('X axis', 'Y axis')
    
    def apply(self):
        self.result = {'X': self.indexToVarNames('X axis'),
                       'Y': self.indexToVarNames('Y axis')
                       }    
