'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
@author: Jimmy Li
'''

from Tkinter import *
import gui.Utils
import gui.dialogs.EditConstraint
from control.DataBoard import DataBoard
import control.Region
import tkMessageBox


class EditorFrame(Toplevel):
    def __init__(self, master):
        Toplevel.__init__(self, master, background="#F0F0F0")
        self.master = master
        self.title("Boolean Region Editor")
        self.protocol("WM_DELETE_WINDOW", self.closeWindow)
        self.resizable(width=TRUE, height=TRUE)
        self.geometry("+%d+%d" % (master.winfo_rootx()+50,
                                  master.winfo_rooty()+50))
        
        #self.tk.call('wm', 'iconphoto', self._w, DataBoard.icon)
        
        self.bind("<Control-KeyRelease-z>", gui.Utils.undo)
        self.bind("<Control-KeyRelease-r>", gui.Utils.redo)
        
        editFrame = Frame(self, background="#F0F0F0")
        editFrame.grid(row=0, column=0, sticky=(N,S,E,W))
        self.rowconfigure(0, weight=1)
        self.columnconfigure(0, weight=1)
        
        editFrame.rowconfigure(1, weight=1)
        editFrame.columnconfigure(0, weight=1)
        editFrame.columnconfigure(1, weight=1)
        editFrame.columnconfigure(2, weight=1)
        Label(editFrame, text="Union", background="#F0F0F0").grid(row=0, column=0, padx=10, pady=5)
        
        regionListFrame = Frame(editFrame)
        regionListFrame.grid(row=1, column=0, sticky=(N,S,E,W), padx=10, pady=5)
        scrollbar = Scrollbar(regionListFrame, orient=VERTICAL)
        self.UnionListBox = Listbox(regionListFrame, exportselection=0, height=30, selectmode=MULTIPLE, yscrollcommand=scrollbar.set)
        scrollbar.config(command=self.UnionListBox.yview)
        scrollbar.pack(side=RIGHT, fill=Y)
        self.UnionListBox.pack(side=TOP, fill=BOTH, expand=1)
        
        Label(editFrame, text="Exclusion", background="#F0F0F0").grid(row=0, column=1, padx=10, pady=5)
        
        regionListFrame = Frame(editFrame)
        regionListFrame.grid(row=1, column=1, sticky=(N,S,E,W), padx=10, pady=5)
        scrollbar = Scrollbar(regionListFrame, orient=VERTICAL)
        self.ExclusionListBox = Listbox(regionListFrame, exportselection=0, height=30, selectmode=MULTIPLE, yscrollcommand=scrollbar.set)
        scrollbar.config(command=self.ExclusionListBox.yview)
        scrollbar.pack(side=RIGHT, fill=Y)
        self.ExclusionListBox.pack(side=TOP, fill=BOTH, expand=1)
        
        Label(editFrame, text="Intersection", background="#F0F0F0").grid(row=0, column=2, padx=10, pady=5)
        
        regionListFrame = Frame(editFrame)
        regionListFrame.grid(row=1, column=2, sticky=(N,S,E,W), padx=10, pady=5)
        scrollbar = Scrollbar(regionListFrame, orient=VERTICAL)
        self.IntersectionListBox = Listbox(regionListFrame, exportselection=0, height=30, selectmode=MULTIPLE, yscrollcommand=scrollbar.set)
        scrollbar.config(command=self.IntersectionListBox.yview)
        scrollbar.pack(side=RIGHT, fill=Y)
        self.IntersectionListBox.pack(side=TOP, fill=BOTH, expand=1)
        
        buttonFrame = Frame(self, background="#F0F0F0", pady=5)
        buttonFrame.grid(row=1, column=0)
        
        Button(buttonFrame, text="Create", command=self.createBoolRegion).pack(side=LEFT, padx=5)
        Button(buttonFrame, text="Close", command=self.closeWindow).pack(side=LEFT, padx=5)
        
        self.refreshRegionList()
        
    def refreshRegionList(self):
        self.UnionListBox.delete(0, END)
        self.ExclusionListBox.delete(0, END)
        self.IntersectionListBox.delete(0, END)
        
        self.regionListBoxData = []
        
        for index in DataBoard.regions.regions:
            for reg in DataBoard.regions.regions[index]:
                self.regionListBoxData.append(reg)
    
        self.regionListBoxData = sorted(self.regionListBoxData, key=lambda reg: reg.name)
        
        for reg in self.regionListBoxData:
            self.UnionListBox.insert(END, reg.name)
            self.ExclusionListBox.insert(END, reg.name)
            self.IntersectionListBox.insert(END, reg.name)
            
        
    def createBoolRegion(self):
        union = []
        for item in self.UnionListBox.curselection():
            union.append(self.regionListBoxData[int(item)])
        exclu = []
        for item in self.ExclusionListBox.curselection():
            exclu.append(self.regionListBoxData[int(item)])
        inter = []
        for item in self.IntersectionListBox.curselection():
            inter.append(self.regionListBoxData[int(item)])
        
        if len(union) == 0 and len(exclu) == 0 and len(inter) == 0:
            tkMessageBox.showerror("Error", "You did not select anything.")
        
        boolReg = control.Region.BooleanRegion()
        boolReg.union = union
        boolReg.exclusion = exclu
        boolReg.intersection = inter
        DataBoard.booleanRegions[boolReg.id] = boolReg
        DataBoard.selectedRegion = boolReg.id
        
        gui.Utils.modified()
        
        for editor in DataBoard.regEditors:
            editor.refreshRegionList()
            editor.updateSelectedRegion()
        gui.Utils.redrawAllDesigners()
    
    def closeWindow(self):
        gui.Utils.removeBoolEditor(self)
        self.destroy()