'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on Dec 30, 2010

@author: Jimmy Li, Anqi Xu
'''

import socket, asyncore, asynchat
import threading
import sys
import gui.Utils
import tkMessageBox
from control.DataBoard import DataBoard
from Tkinter import NORMAL, DISABLED
import traceback
import time

class Client(asynchat.async_chat):
  def __init__(self, host = 'localhost', port = 5007):
    self.alive = False
    self.addr = (host, port)
    asynchat.async_chat.__init__(self)
    self.create_socket(socket.AF_INET, socket.SOCK_STREAM)
    self.connect(self.addr)
    
    '''
    for i in range(50):
        print 'try loop ', i
        try:        
            print 'trying'
            print 'done trying'
        except:
            if i == 49:
                print 're-raising'
                raise
        else:
            break
        time.sleep(0.1)
    '''
    
    self.input_buffer = ''
    self.set_terminator('\n')
    self.alive = True
    self.lock = threading.RLock()

  def handle_error(self):
    '''
    try:
        self.lock.release()
    except:
        pass
    '''
    t, v, tb = sys.exc_info()
    fatal = False
    if t and v and tb:
        if t == socket.error and len(v.args) >= 2 and v.args[0] == 111: # 111 == connection refused
            errstr = "Could not attach to meta-controller:\n\nConnection refused from " + self.addr[0] + ':' + str(self.addr[1])
            fatal = True
        else:
            errstr = "An error occurred with the connection to the meta-controller: Caught exception: %s (%s %s)" % (t, v, traceback.print_tb(tb))
        
        print errstr
        
        if fatal:
            gui.Utils.detachMetaController()
            
            d = tkMessageBox.askquestion("Error", errstr+"\n\nWould you like to try to attach again?")
            DataBoard.asyncClient = None
            DataBoard.asyncClientThread = None
            DataBoard.attachedToMetaController = False
            DataBoard.mainWindowHandle.runMenu.entryconfig(2, state=NORMAL)
            DataBoard.mainWindowHandle.runMenu.entryconfig(3, state=DISABLED)
            DataBoard.mainWindowHandle.runMenu.entryconfig(4, state=DISABLED)
            DataBoard.mainWindowHandle.runMenu.entryconfig(5, state=NORMAL)
            DataBoard.mainWindowHandle.runMenu.entryconfig(6, state=DISABLED)
            if d == 'yes':
                DataBoard.mainWindowHandle.attachMetaController()
        
    
  def close(self):
    self.alive = False
    asynchat.async_chat.close(self)

  def close_when_done(self):
    self.alive = False
    asynchat.async_chat.close_when_done(self)

  def collect_incoming_data(self, data):
    self.input_buffer = self.input_buffer + data

  def found_terminator(self):
    #print '\n' + repr(self.addr) + '> [' + self.input_buffer + '] (' + str(len(self.input_buffer)) + ')'
    #print 'visualizing log entry'
    #print 'buffer: ', self.input_buffer
    self.lock.acquire()
    try:
        gui.Utils.visualizeLogEntry(self.input_buffer)
    except:
        print 'Error processing log entry received from meta-controller.'   
    self.input_buffer = ''
    self.lock.release()  

  def write(self, data):
    if not data or not self.alive:
      return False
    if data[-1] != '\n':
      data = data + '\n'
    self.push(data)
    return True

'''
# Main
client = Client()
client_thread = threading.Thread(target = asyncore.loop)
client_thread.setDaemon(True)
client_thread.start()
while client.alive:
  data = raw_input('\nType text (Enter q or Q to Quit):')
  if not data:
    continue
  elif data != 'Q' and data != 'q':
    if not client.write(data):
      print '\nWrite failed: something bad happened to connection'
      break
  else:
    break
client.close()
client_thread.join(0.5)
'''

'''
\n':
      data = data + '\n'
    self.push(data)
    return True


# Main
client = Client()
client_thread = threading.Thread(target = asyncore.loop)
client_thread.setDaemon(True)
client_thread.start()
'''
