'''
Created on Dec 28, 2010

@author: Jimmy Li
'''

import math
from playerc import *

class Driver():

    def __init__(self, address = 'localhost', port=6665):
        c = playerc_client(None, address, port)
        if c.connect() != 0:
            raise playerc_error_str()
        
        self.conn = c
        
        position2d = playerc_position2d(c, 0)
        if position2d.subscribe(PLAYERC_OPEN_MODE) != 0:
            raise playerc_error_str()
        
        self.position2d = position2d
        self.currentState = {}
        
        self.velocity = 1.0
        self.yawrate = 2.0
        
    def getState(self):
        r = self.conn.read()
        
        self.currentState['Position X'] = self.position2d.px
        self.currentState['Position Y'] = self.position2d.py
        self.currentState['Velocity'] = self.velocity
        
        return self.currentState
    
    def changeState(self, stateChanges):
        if len(stateChanges.keys()) == 0:
            self.position2d.set_cmd_vel(0.0, 0.0, 0.0, 1)
        
        if stateChanges.has_key('Velocity'):
            self.velocity = stateChanges['Velocity']
            self.position2d.set_cmd_vel(self.velocity, 0.0, self.position2d.pa, 1)
        
        if stateChanges.has_key('Position X') or stateChanges.has_key('Position Y'):
            toX = 0
            toY = 0
            
            if not stateChanges.has_key('Position X'):
                toX = self.position2d.px
            else:
                toX = stateChanges['Position X']
                
            if not stateChanges.has_key('Position Y'):
                toY = self.position2d.py
            else:
                toY = stateChanges['Position Y']

            self._moveTo(toX, toY)
    
    def _moveTo(self, toX, toY):   
        px = self.position2d.px
        py = self.position2d.py
        pa = self.position2d.pa
        
        dx = toX - px
        dy = toY - py
        
        # shift the origin to the position of the robot
        newToX = toX - px
        newToY = toY - py
        
        # get the angle of the destination vector
        angle = 0
        
        if newToX == 0 and newToY == 0:
            # robot is on the destination. Do nothing
            pass
        elif dy == 0:
            if newToX > 0:
                angle = 0
            else:
                angle = math.pi
        elif dx == 0:
            if newToY > 0:
                angle = math.pi/2
            else:
                angle = math.pi * 3 / 2
        else:
            angle = math.atan(math.fabs(newToX)/math.fabs(newToY))
            if newToX > 0 and newToY > 0:
                angle = math.pi/2 - angle 
            elif newToX < 0 and newToY > 0:
                angle = math.pi/2 + angle
            elif newToX < 0 and newToY < 0:
                angle = math.pi * 3 / 2 - angle
            else:
                angle = math.pi * 3 / 2 + angle
      
        if pa < 0:
            pa = math.pi * 2 + pa
        
        if math.fabs(angle - pa) < 0.1:
            yr = 0
        else:
            if angle > pa:
                # turn clock wise
                dangle = angle - pa
                if dangle >= math.pi:
                    yr = math.copysign(self.yawrate, -1)
                else:
                    yr = self.yawrate
            else:
                dangle = pa - angle
                if dangle >= math.pi:
                    yr = self.yawrate
                else:
                    yr = math.copysign(self.yawrate, -1)
        
        self.position2d.set_cmd_vel(self.velocity, 0.0, yr, 1)
    
    
    def cleanup(self):
        self.position2d.unsubscribe()
        self.conn.disconnect()
        