'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2010-05-24

@author: Jimmy Li
'''

from gui.MainWindow import MainWindow
from control.DataBoard import DataBoard
from gui.ExternalEditor import EditorManager
import control.Utils
import control.Region
import gui.Utils

__author__ = "Jimmy Li"
__copyright__ = "Copyright (C) 2011 Mobile Robotics Lab, McGill University"
__license__ = "New BSD License"
__version__ = "1.0.0"

def initDataBoard():
    '''
    Initialize shared data.
    '''
    gui.Utils.rcSetup()
    DataBoard.extEditorManager = EditorManager()
    DataBoard.primes = control.Utils.primes(5000)
    DataBoard.regions = control.Region.RegionHolder()
    
def main():    
    initDataBoard()
    mainWindow = MainWindow()
    DataBoard.mainWindowHandle = mainWindow
    mainWindow.run() # This is not a thread!
    gui.Utils.rcCleanup()
    
if __name__ == '__main__':
    main()
