'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2010-05-26

@author: Jimmy Li
'''

from Tkinter import *
from tkSimpleDialog import Dialog
import control.MetaController
from config.Robots import Robots
from control.DataBoard import DataBoard
import gui.Utils
import control.Utils
import os
import tkMessageBox
import subprocess
import time

class MetaController(Dialog):
    def __init__(self, parent):
        self.stateVarSet = DataBoard.currentStateVarSet
        self.pathname = os.path.dirname(sys.argv[0])
        self.abspathname = os.path.abspath(self.pathname)
        Dialog.__init__(self, parent, "Start Meta-controller on localhost")
    
    def body(self, master):
        Label(master, text="Choose driver:").grid(row=0, column=0, sticky=W, pady=3, padx=8)
        listFrame = Frame(master)
        listFrame.grid(row=1, column=0, sticky=(N, S, W), padx=8)
        scrollbar = Scrollbar(listFrame, orient=VERTICAL)
        self.list = Listbox(listFrame, selectmode=SINGLE, height=20, width=20, yscrollcommand=scrollbar.set, exportselection=0)
        scrollbar.config(command=self.list.yview)
        scrollbar.pack(side=RIGHT, fill=Y)
        self.list.pack(side=RIGHT, fill=BOTH)
        abspath = os.path.join(self.abspathname, 'driver')
                
        self.dirList = sorted(os.listdir(abspath))
        
        self.listData = []
        
        for file in self.dirList:
            if file == '__init__.py':
                continue
            ext = os.path.splitext(file)[1]
            if not ext == '.py':
                continue
            self.list.insert(END, file)
            self.listData.append(file)
            
        master.rowconfigure(1, weight=1)
        master.columnconfigure(1, weight=1)
        
        settingFrame = LabelFrame(master, text="Meta-controller Settings")
        settingFrame.grid(row=0, column=1, padx=8, pady=3, rowspan=2, sticky=(N,S,E,W))
        
        Label(settingFrame, text="Port").grid(row=0, column=0, padx=5, pady=5, sticky=E)
        self.comPortEntry = Entry(settingFrame)
        self.comPortEntry.grid(row=0, column=1, padx=2, sticky=(E,W))
        self.comPortEntry.insert(0, DataBoard.cachePort)
        
        Label(settingFrame, text="Log File").grid(row=1, column=0, padx=5, pady=5, sticky=E)
        self.logFileEntry = Entry(settingFrame, width=55)
        self.logFileEntry.grid(row=1, column=1, padx=2, sticky=(E,W))
        self.logFileEntry.insert(0, control.Utils.getNewLogFilePath())
        
        settingFrame.columnconfigure(1, weight=1)
        
        #self.attachVar = StringVar()
        #Checkbutton(settingFrame, variable=self.attachVar, onvalue='yes', offvalue='no').grid(row=2, column=0, sticky=E)
        #Label(settingFrame, text="Attach upon starting").grid(row=2, column=1, sticky=W)
        #self.attachVar.set('yes')
        
    
    def buttonbox(self):
        # add standard button box. override if you don't want the
        # standard buttons
        
        box = Frame(self)

        self.startButton = Button(box, text="Start", width=10, command=self.startMetaController)
        self.startButton.pack(side=LEFT, padx=5, pady=5)
        
        self.closeButton = Button(box, text="Cancel", width=10, command=self.closeDialog)
        self.closeButton.pack(side=LEFT, padx=5, pady=5)

        box.grid(row=1, column=0, pady=5, padx=5)
    
    def startMetaController(self):
        if DataBoard.modified or DataBoard.currentFile == '':
            answer = tkMessageBox.askquestion("Start Meta-controller", "You must save your work before you can run it. Would you like to save your work now?")
            if answer == 'yes':
                DataBoard.mainWindowHandle.saveRobotDesign()
                if DataBoard.currentFile == '':
                    return
            else:
                return
        if len(self.list.curselection()) <= 0:
            tkMessageBox.showerror("Start Meta-controller", "You must choose a robot driver. If you do not see anything in the list box, then you need to first create a robot driver and place it in the driver folder.")
            return

        driver = self.listData[int(self.list.curselection()[0])]
        subprocess.Popen(['python', os.path.join(self.abspathname, 'runmc.py'), DataBoard.currentFile, driver, self.comPortEntry.get(), self.logFileEntry.get()])
        DataBoard.cachePort = int(self.comPortEntry.get())
        '''
        if self.attachVar.get() == 'yes':
            # TODO: Right now, I'm waiting for one second so that meta controller can started
            # But what if the meta controller takes more than one second to start? Better solution needed.
            self.startButton.configure(state=DISABLED)
            self.closeButton.configure(state=DISABLED)
            DataBoard.mainWindowHandle.runMenu.entryconfig(2, state=DISABLED)
            DataBoard.mainWindowHandle.runMenu.entryconfig(3, state=NORMAL)
            DataBoard.mainWindowHandle.runMenu.entryconfig(4, state=NORMAL)
            DataBoard.mainWindowHandle.runMenu.entryconfig(5, state=DISABLED)
            DataBoard.mainWindowHandle.runMenu.entryconfig(6, state=DISABLED)
            gui.Utils.attachMetaController(port=int(self.comPortEntry.get()))
        '''
        
        self.closeDialog()
        
        
    '''
    def stopMetaController(self):
        #control.StateBoard.StateBoard.metaControlStarted = False
        self.startButton.config(state=NORMAL)
        self.ipEntry.config(state=NORMAL)
        #self.stopButton.config(state=DISABLED)
        self.statusLabel.config(text="Meta-controller is stopped.")
    '''
    
    def closeDialog(self):
        self.cancel()
