'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2011-06-14

@author: Jimmy Li
'''

from Tkinter import *
from tkSimpleDialog import Dialog
import tkMessageBox

class EditConstraint(Dialog):
    def __init__(self, parent, title):
        Dialog.__init__(self, parent, title)
        
class Position(EditConstraint):
    '''
    classdocs
    '''

    def __init__(self, parent, posName, posVal):
        '''
        Constructor
        '''
        self.posName = posName
        self.posVal = posVal
        EditConstraint.__init__(self, parent, "Edit Position")
        
    def body(self, master):
        Label(master, text=self.posName+":").pack(side=LEFT, ipadx=5, pady=5)
        self.posEntry = Entry(master, width=13)
        self.posEntry.pack(side=LEFT, ipadx=5, pady=5)
        self.posEntry.insert(0, str(self.posVal))
        
    def validate(self):
        try:
            float(self.posEntry.get())
            return True
        except ValueError:
            tkMessageBox.showerror("Error", "Invalid floating point number.")
            return False
    
    def apply(self):
        self.result = float(self.posEntry.get())
    
class Constraint(EditConstraint):
    '''
    classdocs
    '''
    
    def __init__(self, parent, consName, lowerb, upperb):
        self.consName = consName
        self.lowerb = lowerb
        self.upperb = upperb
        EditConstraint.__init__(self, parent, "Edit Constraint")
    
    def body(self, master):
        Label(master, text=self.consName+" lower bound:").grid(row=0, column=0, sticky=E, padx=5, pady=5)
        self.lowerBEntry = Entry(master, width=13)
        self.lowerBEntry.grid(row=0, column=1, padx=5)
        self.lowerBEntry.insert(0, str(self.lowerb))
        
        Label(master, text=self.consName+" upper bound:").grid(row=1, column=0, sticky=E, padx=5, pady=5)
        self.upperBEntry = Entry(master, width=13)
        self.upperBEntry.grid(row=1, column=1, padx=5)
        self.upperBEntry.insert(0, str(self.upperb))
        
    def validate(self):
        lowerb = self.lowerBEntry.get()
        upperb = self.upperBEntry.get()
        
        if lowerb == 'inf' or lowerb == '-inf':
            self.newLowerb = 'inf'
        else:
            try:
                self.newLowerb = float(lowerb)
            except ValueError:
                tkMessageBox.showerror("Error", "Lower bound is an invalid floating point number.")
                return False
        
        if upperb == 'inf' or upperb == '+inf':
            self.newUpperb = 'inf'
        else:
            try:
                self.newUpperb = float(upperb)
            except ValueError:
                tkMessageBox.showerror("Error", "Upper bound is an invalid floating point number.")
                return False
                
        return True
    
    def apply(self):
        lowerb = self.newLowerb
        upperb = self.newUpperb
        self.result = [lowerb, upperb]
