'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
@author: Jimmy Li
'''

import threading
import time
import os
import gui.Utils
import control.Utils
from control.DataBoard import DataBoard
import math

class PlaybackThread(threading.Thread):
    def __init__(self, logfile):
        self.logfile = logfile
        self.loglines = []
        self.lock = threading.Lock()
        while logfile:
            line = logfile.readline()
            if line == '':
                break
            line = line.strip()
            if line == '':
                continue
            
            firstCloseSqBrack = line.find(']')
            lineTime = float(line[1:firstCloseSqBrack])
            self.loglines.append({'time': lineTime, 'line':line})
                
        self.started = True
        self.paused = False
        self.onLogIndex = 0
        threading.Thread.__init__(self)
    
    def jumpToTime(self, val, startIndex=None, endIndex=None):
        '''
        Binary search to find the place we should jump to
        '''
        
        #print 'jumping to', val
        if startIndex == None or endIndex == None:
            self.jumpToTime(val, 0, len(self.loglines))
            return
        checkIndex = (endIndex + startIndex)/2
        checkTime = self.loglines[checkIndex]['time']
        error = math.fabs((checkTime - self.loglines[0]['time']) - val)
        if checkIndex + 1 < endIndex:
            timeR = (self.loglines[checkIndex + 1]['time'] - self.loglines[0]['time'])
            errorR = math.fabs(timeR - val)
            if (errorR < error) or (errorR == error and val > timeR):
                self.jumpToTime(val, checkIndex + 1, endIndex)
                return
                
        if checkIndex - 1 >= startIndex:
            timeL = (self.loglines[checkIndex - 1]['time'] - self.loglines[0]['time'])
            errorL = math.fabs(timeL - val)
            if (errorL < error) or (errorL == error and val <= timeL):
                self.jumpToTime(val, startIndex, checkIndex)
                return
        
        self.onLogIndex = checkIndex
        
    def run(self):
        while 1:
            if not self.started:
                break
            if self.paused:
                time.sleep(0.01)
                continue
            if self.onLogIndex >= len(self.loglines):
                time.sleep(0.01)
                continue
            line = self.loglines[self.onLogIndex]['line']
            logtime = self.loglines[self.onLogIndex]['time']
            sleeptime = 0.0
            if self.onLogIndex > 0:
                sleeptime = logtime - self.loglines[self.onLogIndex-1]['time']
            DataBoard.playbackControllerHandle.updateSliderPosition(logtime)
            time.sleep(sleeptime)
            gui.Utils.visualizeLogEntry(line)
            self.onLogIndex += 1
        
        gui.Utils.removeRobotImage()
        
        '''
        if not DataBoard.logPlaybackThread == None:
            DataBoard.mainWindowHandle.stopLogPlayback()
        '''
        