'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on Dec 30, 2010

@author: Jimmy Li
'''

import sys
from control.DataBoard import DataBoard
from control.StateBoard import StateBoard
import control.Utils
import control.MetaController
import control.Region
import time
import threading

class InputThread(threading.Thread):
    def __init__(self):
        threading.Thread.__init__(self)
    
    def run(self):
        try:
            while 1:
                print 'runmc>>',
                input = raw_input()
                if input == 'quit':
                    StateBoard.metaControlStarted = False
                    break
        
        except KeyboardInterrupt:
            print 'Keyboard Interrupt'
            StateBoard.metaControlStarted = False
            print "\n"
        except EOFError:
            pass
        
def initDataBoard():
    '''
    Initialize shared data.
    '''
    DataBoard.primes = control.Utils.primes(5000)
    DataBoard.regions = control.Region.RegionHolder()
    
def usage():
    print """
    Meta-Controller Usage:
    
    python runmc.py saveFile driver [port [log_file]]
    
    saveFile: The gssp save file, created using the gui. Usually has 
    .gssp extension
    
    driver: The python script under the drivers folder that you want to use 
    as the robot-specific driver. Example: my_driver.py
    
    port: The port to which GSSP gui processes can attach to view the 
    robot during execution. Defaults to 9551
    
    log_file: Where the meta-controller should save the log file.
    Defaults to ./data/log_current-datetime.gssplog
    """

def main():
    if len(sys.argv) < 2:
        usage()
        sys.exit()
    
    saveFile = sys.argv[1]
    driver = sys.argv[2]
    
    if len(sys.argv) > 3:
        port = int(sys.argv[3])
    else:
        port = DataBoard.defaultPort
    
    if len(sys.argv) > 4:
        logfile = sys.argv[4]
    else:
        logfile = control.Utils.getNewLogFilePath()
    
    file = open(logfile, 'w')
    file.close()
    
    initDataBoard()
    
    file = open(saveFile)
    control.Utils.loadDesignFromFile(file)
    file.close()
    
    metaController = control.MetaController.MetaController(driver, port, logfile)
    metaController.setDaemon(True)
    StateBoard.metaControlStarted = True
    metaController.start()
    
    print "\nMeta-Controller started. Type quit to terminate.\n"
    
    inputThread = InputThread()
    inputThread.setDaemon(True)
    inputThread.start()
    
    while StateBoard.metaControlStarted:
        time.sleep(0.3)
    
    metaController.join(3)
    
    print "\nMeta-Controller stopped.\n"
    
if __name__ == '__main__':
    main()
