'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2010-08-16

@author: Jimmy Li
'''

import threading
import socket
import time
import DataBoard
import math

class Communication(threading.Thread):
    
    def __init__(self):
        threading.Thread.__init__(self)
        
        self.lock = threading.Lock()
        self.host = '127.0.0.1'
        self.port = 9559
        self.previousDirection = ''
        self.currentTarget = {}
        self.stop = False
        self.nextWaypointDistance = 5
        self.error = 2
        self.stateBuffer = ''
    
    def run(self):
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        try:
            s.connect((self.host, self.port))
        except socket.error:
            print 'Connection not available at this time. Try again later.'
        else:
            s.setblocking(0)
            while (1):
                
                if self.stop:
                    break
                
                time.sleep(0.1)
                
                try:
                    data = s.recv(4096)
                    if not data:
                        break
                    
                    # We're trying to get the current state of the robot here.
                    # Each sample of the robot's state ends with a \n. 
                    split = data.rsplit("\n",1)
                    if len(split) == 1:
                        # No end line found. Add data to buffer and wait
                        self.stateBuffer += data
                    elif len(split) == 2:
                        stateStr = self.stateBuffer + split[0]
                        self.stateBuffer = split[1]
                    else:
                        # Something is not right
                        raise ValueError
                    # Be careful. stateStr may contain several samples of state, 
                    # separated by \n. We want the latest sample.
                    samples = stateStr.rsplit("\n", 1)   
                    sample = ''         
                    if len(samples) == 1:
                        # Separator not found
                        sample = samples[0]
                    elif len(samples) == 2:
                        sample = samples[1]
                    else:
                        raise ValueError
                    
                    exec('self.state = ' + sample)
                                        
                    self.lock.acquire()
                    DataBoard.DataBoard.state = self.state
                    self.lock.release()
                                        
                except socket.error:
                    pass
                except ValueError:
                    print 'Something weird happened with the data received.'
                    pass
                
                command = ''
                
                if DataBoard.DataBoard.direction == 'w':
                    if not self.previousDirection == 'w' or math.fabs(self.currentTarget['Position Y'] - DataBoard.DataBoard.state['Position Y']) < self.error:
                        self.previousDirection = 'w'
                        self.currentTarget['Position Y'] = DataBoard.DataBoard.state['Position Y'] + self.nextWaypointDistance
                        command = "cancelGoTo('driveTo')\n"
                        command += "goTo({'Position Y': %d, 'Position X': %d}, name='driveTo', blocking=False)\n" % (self.currentTarget['Position Y'], DataBoard.DataBoard.state['Position X'])
             
                elif DataBoard.DataBoard.direction == 's':
                    if not self.previousDirection == 's' or math.fabs(self.currentTarget['Position Y'] - DataBoard.DataBoard.state['Position Y']) < self.error:
                        self.previousDirection = 's'
                        self.currentTarget['Position Y'] = DataBoard.DataBoard.state['Position Y'] - self.nextWaypointDistance
                        command = "cancelGoTo('driveTo')\n"
                        command += "goTo({'Position Y': %d, 'Position X': %d}, name='driveTo', blocking=False)\n" % (self.currentTarget['Position Y'], DataBoard.DataBoard.state['Position X'])
                           
                elif DataBoard.DataBoard.direction == 'a':
                    if not self.previousDirection == 'a' or math.fabs(self.currentTarget['Position X'] - DataBoard.DataBoard.state['Position X']) < self.error:
                        self.previousDirection = 'a'
                        self.currentTarget['Position X'] = DataBoard.DataBoard.state['Position X'] - self.nextWaypointDistance
                        command = "cancelGoTo('driveTo')\n"
                        command += "goTo({'Position X': %d, 'Position Y': %d}, name='driveTo', blocking=False)\n" % (self.currentTarget['Position X'], DataBoard.DataBoard.state['Position Y'])
                        
                elif DataBoard.DataBoard.direction == 'd':
                    if not self.previousDirection == 'd' or math.fabs(self.currentTarget['Position X'] - DataBoard.DataBoard.state['Position X']) < self.error:
                        self.previousDirection = 'd'
                        self.currentTarget['Position X'] = DataBoard.DataBoard.state['Position X'] + self.nextWaypointDistance
                        command = "cancelGoTo('driveTo')\n"
                        command += "goTo({'Position X': %d, 'Position Y': %d}, name='driveTo', blocking=False)\n" % (self.currentTarget['Position X'], DataBoard.DataBoard.state['Position Y'])
                        
                elif DataBoard.DataBoard.direction == 'c':
                    if not self.previousDirection == 'c':
                        self.previousDirection = 'c'
                        command = "cancelGoTo('driveTo')\n"
                
                
                try:
                    s.sendall(command)
                except socket.error:
                    pass
                
                
        s.close()
            
