'''
Copyright (c) 2011, Mobile Robotics Lab, McGill University
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Mobile Robotics Lab, McGill University nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MOBILE ROBOTICS LAB, MCGILL UNIVERSITY BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

'''
Created on 2010-08-13

@author: Jimmy Li
'''

import threading
import time
import control.StateBoard
import socket
import control.Runtime

class TaskThread(threading.Thread):
    '''
    classdocs
    '''


    def __init__(self, region, port, name=None):
        '''
        Constructor
        '''
        
        threading.Thread.__init__(self)
        self.region = region
        self.host = ''
        self.port = port
        if name == None:
            name = port
        #self.commands = ''
        self.lock = threading.RLock()
        self.priority = region.priority
        self.runTimeEnv = control.Runtime.Environment(region, self, 'TCP '+str(self.port))
        self.reqStateChange = {}
        self.alive = True
        self.codeBuffer = ''
        self.description = repr(name) + ' TCP controller thread'
    
    def run(self):
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        s.bind((self.host, self.port))
        s.listen(1)
        conn, addr = s.accept()
        
        self.lock.acquire()
        control.DataBoard.DataBoard.metaControllerHandle.log('TCP', str(self.port)+' connected by '+str(addr))
        self.lock.release()
        
        conn.setblocking(0)
        while 1:
            
            if not control.StateBoard.StateBoard.metaControlStarted:
                break
            
            if not self.region.inside and self.region.bounded:
                '''
                Thread is paused
                try: 
                    data = conn.recv(4096)          
                except socket.error:
                    pass
                '''

                time.sleep(0.1)
                continue
                        
            self.lock.acquire()
            try:
                conn.sendall(repr(control.StateBoard.StateBoard.currentState)+"\n")
            except socket.error:
                pass
            self.lock.release()
            
            try: 
                data = conn.recv(4096)  
            except socket.error:
                pass
            else:
                if not data:
                    break
                #data = self.codeBuffer + data
                split = data.rsplit("\n", 1)
                #print 'split: ', split
                if len(split) == 1:
                    # No end line found. Add data to buffer and wait
                    self.codeBuffer += split[0]
                elif len(split) == 2:
                    # We want to run split[0], and put split[1] into buffer
                    code = self.codeBuffer + split[0] + "\n"
                    self.codeBuffer = split[1]
                    control.DataBoard.DataBoard.metaControllerHandle.log('TCP', str(self.port)+': Received command '+code.replace("\n", "\\n"))
                    #print code
                    
                    self.runTimeEnv.runCodeBlock(code)
            
            time.sleep(0.1)
                
        conn.close()
        s.close()
        
        self.lock.acquire()
        self.reqStateChange.clear()
        self.lock.release()
        
        self.alive = False
        